EAS_PlaceableHusbandryAnimals = {}

function EAS_PlaceableHusbandryAnimals.onPeriodChanged(self)
	if self.isServer then
		local spec = self.spec_husbandryAnimals
		local clusters = spec.clusterSystem:getClusters()
		local animalSystem = g_currentMission.animalSystem

		for _, cluster in ipairs(clusters) do
			cluster:onPeriodChanged()

            EAS_PlaceableHusbandryAnimals.inseminateClusterIfNeeded(spec, cluster)
            EAS_PlaceableHusbandryAnimals.calculateIfInseminationIsSuccessful(spec, cluster)

			local numNewAnimals = cluster:updateReproduction()
			if numNewAnimals > 0 then
				if numNewAnimals > 0 then
					local subType = animalSystem:getSubTypeByIndex(cluster:getSubTypeIndex())
                    local numMaleOffspring = 0

                    if subType.malePart ~= nil and animalSystem:getSubTypeByName(subType.malePart) ~= nil then
                        local malePartSubType = animalSystem:getSubTypeByName(subType.malePart)

                        for i=1, numNewAnimals do
                            numMaleOffspring = numMaleOffspring + math.random(0, 1)
                        end

                        if numMaleOffspring > 0 then
                            local newMaleCluster = animalSystem:createClusterFromSubTypeIndex(malePartSubType.subTypeIndex)
                            newMaleCluster.numAnimals = numMaleOffspring
                            newMaleCluster:changeHealth(100)
                            spec.clusterSystem:addPendingAddCluster(newMaleCluster)

                            if malePartSubType.statsBreedingName ~= nil then
                                g_farmManager:updateFarmStats(self:getOwnerFarmId(), malePartSubType.statsBreedingName, numMaleOffspring)
                            end
                        end
                    end

					local newCluster = animalSystem:createClusterFromSubTypeIndex(cluster:getSubTypeIndex())
                    local numFemaleAnimals = numNewAnimals - numMaleOffspring
					newCluster.numAnimals = numFemaleAnimals
                    newCluster:changeHealth(100)
					spec.clusterSystem:addPendingAddCluster(newCluster)
					if subType.statsBreedingName ~= nil then
						g_farmManager:updateFarmStats(self:getOwnerFarmId(), subType.statsBreedingName, newCluster.numAnimals)
					end
				end
			end
		end
		self:raiseActive()
	end
end

PlaceableHusbandryAnimals.onPeriodChanged = Utils.overwrittenFunction(PlaceableHusbandryAnimals.onPeriodChanged, EAS_PlaceableHusbandryAnimals.onPeriodChanged)

function EAS_PlaceableHusbandryAnimals.updateOutput(self, overrideFunction, superFunc, foodFactor, productionFactor, globalProductionFactor)
	if self.isServer then
		local clusters = self.spec_husbandryAnimals.clusterSystem:getClusters()

		local totalNumAnimals = self:getNumOfAnimals()
        local maxAnimalsAllowed = self:getMaxNumOfAnimals()
        if totalNumAnimals > maxAnimalsAllowed then
            local overcrowdingFactor = ((totalNumAnimals / maxAnimalsAllowed) - 1.0) * 1.5
            foodFactor = math.max(foodFactor - overcrowdingFactor, 0.0)
        end

		for _, cluster in ipairs(clusters) do
			cluster:updateHealth(foodFactor)
            EAS_AnimalCluster.removeByHealthIfNeeded(cluster)
		end
		self:raiseActive()
	end
	superFunc(self, foodFactor, productionFactor, globalProductionFactor)
end

PlaceableHusbandryAnimals.updateOutput = Utils.overwrittenFunction(PlaceableHusbandryAnimals.updateOutput, EAS_PlaceableHusbandryAnimals.updateOutput)

function EAS_PlaceableHusbandryAnimals.addAnimals(self, superFunc, subTypeIndex, numAnimals, age)
    local cluster = g_currentMission.animalSystem:createClusterFromSubTypeIndex(subTypeIndex)

    local subType = g_currentMission.animalSystem:getSubTypeByIndex(subTypeIndex)
    local neededAge = subType.reproductionMinAgeMonth + subType.reproductionDurationMonth

	if cluster:getSupportsMerging() then
		cluster.numAnimals = numAnimals
		cluster.age = age
		cluster.subTypeIndex = subTypeIndex

        if age >= neededAge and cluster:getSupportsReproduction() then
            cluster.hadABirth = true
        end

		self:addCluster(cluster)
	else
		for i = 1, numAnimals do
			cluster = g_currentMission.animalSystem:createClusterFromSubTypeIndex(subTypeIndex)
			cluster.numAnimals = 1
			cluster.age = age

            if age >= neededAge and cluster:getSupportsReproduction() then
                cluster.hadABirth = true
            end

			self:addCluster(cluster)
		end
	end
end

PlaceableHusbandryAnimals.addAnimals = Utils.overwrittenFunction(PlaceableHusbandryAnimals.addAnimals, EAS_PlaceableHusbandryAnimals.addAnimals)

function EAS_PlaceableHusbandryAnimals.onReadStream(self, superFunc, streamId, connection)
    superFunc(self, streamId, connection)
    self.spec_husbandryAnimals.automaticInsemination = streamReadBool(streamId)
end

PlaceableHusbandryAnimals.onReadStream = Utils.overwrittenFunction(PlaceableHusbandryAnimals.onReadStream, EAS_PlaceableHusbandryAnimals.onReadStream)

function EAS_PlaceableHusbandryAnimals.onWriteStream(self, superFunc, streamId, connection)
    superFunc(self, streamId, connection)
    streamWriteBool(streamId, self.spec_husbandryAnimals.automaticInsemination or false)
end

PlaceableHusbandryAnimals.onWriteStream = Utils.overwrittenFunction(PlaceableHusbandryAnimals.onWriteStream, EAS_PlaceableHusbandryAnimals.onWriteStream)

function EAS_PlaceableHusbandryAnimals.saveToXMLFile(self, superFunc, xmlFile, key, usedModNames)
    superFunc(self, xmlFile, key, usedModNames)
    xmlFile:setBool(key.."#automaticInsemination", self.spec_husbandryAnimals.automaticInsemination or false)
end

PlaceableHusbandryAnimals.saveToXMLFile = Utils.overwrittenFunction(PlaceableHusbandryAnimals.saveToXMLFile, EAS_PlaceableHusbandryAnimals.saveToXMLFile)

function EAS_PlaceableHusbandryAnimals.loadFromXMLFile(self, superFunc, xmlFile, key)
    superFunc(self, xmlFile, key)
    self.spec_husbandryAnimals.automaticInsemination = xmlFile:getBool(key.."#automaticInsemination", false)
end

PlaceableHusbandryAnimals.loadFromXMLFile = Utils.overwrittenFunction(PlaceableHusbandryAnimals.loadFromXMLFile, EAS_PlaceableHusbandryAnimals.loadFromXMLFile)

----------------------- Extension methods ------------------------------------

function EAS_PlaceableHusbandryAnimals.inseminateClusterIfNeeded(spec, cluster)
    if cluster.clusterSystem.owner.ownerFarmId == FarmManager.INVALID_FARM_ID then
        return
    end

    if EAS_AnimalCluster.canBeInseminate(cluster) then
        if EAS_PlaceableHusbandryAnimals.isAppropriateMalePartAvailable(spec, cluster) then
            EAS_AnimalCluster.inseminate(cluster, cluster:getNumAnimals())
        elseif spec.automaticInsemination then
            EAS_AnimalCluster.inseminate(cluster, cluster:getNumAnimals())
            EAS_InseminationManager.collectInseminationCost(spec, cluster:getNumAnimals())
        end
    end
end

function EAS_PlaceableHusbandryAnimals.isAppropriateMalePartAvailable(spec, cluster)
	local clusters = spec.clusterSystem:getClusters()
	local animalSystem = g_currentMission.animalSystem
	local subType = animalSystem:getSubTypeByIndex(cluster:getSubTypeIndex())

    for _, currentCluster in ipairs(clusters) do
        local clusterSubType = animalSystem:getSubTypeByIndex(currentCluster:getSubTypeIndex())
        if clusterSubType.name == subType.malePart and currentCluster.age >= clusterSubType.reproductionMinAgeMonth then
            return true
        end
    end

    return false
end

function EAS_PlaceableHusbandryAnimals.calculateIfInseminationIsSuccessful(spec, cluster)
    if cluster.reproduction ~= 0 or not cluster.isInseminated then
        return
    end

    local successfulAnimals = 0
    local numAnimals = cluster:getNumAnimals()
    local probability = EAS_AnimalCluster.getInseminationProbability(cluster)

    for i=1, numAnimals do
        local successful = math.random(1, 100) <= probability
        if successful then
            successfulAnimals = successfulAnimals + 1
        end
    end

    if successfulAnimals == 0 then
        cluster.isInseminated = false
    elseif successfulAnimals ~= numAnimals then
        local clusterClone = cluster:clone()
        clusterClone.isInseminated = false
        clusterClone.numAnimals = numAnimals - successfulAnimals
        cluster.numAnimals = successfulAnimals
        spec.clusterSystem:addPendingAddCluster(clusterClone)
    end
end
