EAS_InGameMenuSettingsFrameExtension = {}
local EAS_InGameMenuSettingsFrameExtension_mt = Class(EAS_InGameMenuSettingsFrameExtension)

function EAS_InGameMenuSettingsFrameExtension.new()
    local self = setmetatable({}, EAS_InGameMenuSettingsFrameExtension_mt)

    self.animalsCanDieState = 2
    self:init()

    Mission00.loadItemsFinished = Utils.appendedFunction(Mission00.loadItemsFinished, EAS_InGameMenuSettingsFrameExtension.loadFromXMLFile)
    FSCareerMissionInfo.saveToXMLFile = Utils.appendedFunction(FSCareerMissionInfo.saveToXMLFile, EAS_InGameMenuSettingsFrameExtension.saveToXMLFile)
    FSBaseMission.sendInitialClientState = Utils.appendedFunction(FSBaseMission.sendInitialClientState, EAS_InGameMenuSettingsFrameExtension.sendInitialClientState)
    InGameMenuSettingsFrame.updateGameSettings = Utils.appendedFunction(InGameMenuSettingsFrame.updateGameSettings, EAS_InGameMenuSettingsFrameExtension.updateGameSettings)

    return self
end

function EAS_InGameMenuSettingsFrameExtension:init()
    local settingsPage = g_inGameMenu.pageSettings
	local scrollPanel = settingsPage.gameSettingsLayout

    for _, element in pairs(scrollPanel.elements) do
		if element.name == "sectionHeader" then
            self.sectionHeader = element:clone(scrollPanel)
        end

		if element.typeName == "Bitmap" then
			if element.elements[1].typeName == "BinaryOption" then
                self.binaryOptionElement = element
            end
		end

        if self.sectionHeader ~= nil and self.binaryOptionElement ~= nil then
            break
        end	
	end

	self.sectionHeader:setText(g_i18n:getText("eas_settings_sectionHeader"))

    local parent = self.binaryOptionElement:clone(scrollPanel)
    local animalsCanDie = parent.elements[1]
    parent.id = nil

    parent.elements[2]:setText(g_i18n:getText("eas_settings_animalsCanDieTitle"))

    animalsCanDie.elements[1]:setText(g_i18n:getText("eas_settings_animalsCanDieTooltip"))
    animalsCanDie.id = "animalsCanDieId"
    animalsCanDie.onClickCallback = EAS_InGameMenuSettingsFrameExtension.animalsCanDieChanged
    settingsPage.animalsCanDie = animalsCanDie

    parent:setVisible(true)
    parent:setDisabled(false)

	scrollPanel:invalidateLayout()
end

function EAS_InGameMenuSettingsFrameExtension.sendInitialClientState(_, connection, user, farm)
    connection:sendEvent(EAS_SettingsEvent.new())
end

function EAS_InGameMenuSettingsFrameExtension.updateGameSettings(settingsPage)
    local animalsCanDie = settingsPage.animalsCanDie

    if animalsCanDie ~= nil then
        local state = g_eas_inGameMenuSettingsFrameExtension.animalsCanDieState
        animalsCanDie:setState(state)
    end
end

function EAS_InGameMenuSettingsFrameExtension.animalsCanDieChanged(_, state)
    g_eas_inGameMenuSettingsFrameExtension:updateAnimalsCanDie(state)
end

function EAS_InGameMenuSettingsFrameExtension:updateAnimalsCanDie(state, noEventSend)
    if state ~= self.animalsCanDieState then
        self.animalsCanDieState = state
        EAS_SettingsEvent.sendEvent(noEventSend)
    end
end

function EAS_InGameMenuSettingsFrameExtension:canAnimalsDie()
    return self.animalsCanDieState == 2
end

function EAS_InGameMenuSettingsFrameExtension:loadFromXMLFile()
    local savegameDirectory = g_currentMission.missionInfo.savegameDirectory

    if savegameDirectory ~= nil then
        local filePath = savegameDirectory.."/eas_settings.xml"
        local key = "settings"
        local xmlFile = XMLFile.loadIfExists("eas_settings", filePath, key)

        if xmlFile ~= nil then
            local animalsCanDie = xmlFile:getBool(key.."#animalsCanDie")

            if animalsCanDie then
                g_eas_inGameMenuSettingsFrameExtension:updateAnimalsCanDie(2)
            else
                g_eas_inGameMenuSettingsFrameExtension:updateAnimalsCanDie(1)
            end

            xmlFile:delete()
        end
    end
end

function EAS_InGameMenuSettingsFrameExtension:saveToXMLFile()
    local savegameDirectory = g_currentMission.missionInfo.savegameDirectory

    if savegameDirectory ~= nil then
        local filePath = savegameDirectory.."/eas_settings.xml"
        local key = "settings"
        local xmlFile = XMLFile.create("eas_settings", filePath, key)

        if xmlFile ~= nil then
            xmlFile:setBool(key.."#animalsCanDie", g_eas_inGameMenuSettingsFrameExtension:canAnimalsDie())
            xmlFile:save()
            xmlFile:delete()
        end
    end
end

g_eas_inGameMenuSettingsFrameExtension = EAS_InGameMenuSettingsFrameExtension.new()