-- quickScreenshotMode
-- by modelleicher 17.11.2024
-- Hotkey Mod to quickly change into screenshot mode preset 

quickScreenshotMode = {}
addModEventListener(quickScreenshotMode)

local modSettingsDirectory = g_currentModSettingsDirectory
quickScreenshotMode.modSettingsDir = modSettingsDirectory

function quickScreenshotMode:loadMap(name)
	
	-- load FOV from modSettings first 
	local filename = quickScreenshotMode.modSettingsDir.."settings.xml"
	local key = "settings"

	-- also create the folder if it doesn't exist
	createFolder(quickScreenshotMode.modSettingsDir)
	local xmlFile = XMLFile.loadIfExists("settingsXML", filename, key)
	
	-- default FOV set to 30
	self.FOV = 30
	
	-- if the XML file exists, load FOV from there. If it doesn't (first time starting with this mod) create it.
	if xmlFile ~= nil then
	
		self.FOV = xmlFile:getInt(key..".camera#FOV") or self.FOV

		xmlFile:delete()
	else
		local xmlFile = XMLFile.create("settingsXML", filename, key)

		if xmlFile ~= nil then 		
			xmlFile:setInt(key..".camera#FOV", self.FOV)
			
			xmlFile:save()
			xmlFile:delete()
		end
	end
	
	self.fovBackups = {}

end

-- InputBinding Callback to Toggle between Screenshot Mode and Regular Mode. 
function quickScreenshotMode:QUICK_SCREENSHOT_MODE_TOGGLE()
	
	-- I tried to directly disable the Hud but it always left the Crosshairs back. So now I use the consoleCommandToggleVisibility command but since its a toggle I adjust everything that follows to its result 
	g_currentMission.hud:consoleCommandToggleVisibility()
	
	-- everything else is based on if the hud is visible or not
	local isVisible = g_currentMission.hud.isVisible
	
	-- accessing the camera of the local player this also works in a vehicle in 25
	local player = g_localPlayer
	local cameraNode = player:getCurrentCameraNode()	
	
	if not isVisible then
		
		-- storing the current FOV as backup for the current cameraNode 
		if self.fovBackups[tostring(cameraNode)] == nil then
			self.fovBackups[tostring(cameraNode)] = getFovY(cameraNode)
		end
		
		-- setting new FOV 
		setFovY(cameraNode, math.rad(self.FOV))

	else
	
		-- restoring original FOV using the backup Table 
		if self.fovBackups[tostring(cameraNode)] ~= nil then	
			setFovY(cameraNode, self.fovBackups[tostring(cameraNode)])
		end
	end
	
end



function quickScreenshotMode:update(dt)

	-- always make sure that the actionEvent is registered no matter where you are 
	local _, actionEventId = g_inputBinding:registerActionEvent('QUICK_SCREENSHOT_MODE_TOGGLE', self, quickScreenshotMode.QUICK_SCREENSHOT_MODE_TOGGLE, false, true, false, true)
	g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW)
    g_inputBinding:setActionEventText(actionEventId, g_i18n:getText("QUICK_SCREENSHOT_MODE_TOGGLE"))
	
end



