--[[
	AutoTurnOffTurnLights.lua
	
	Author: 	Ifko[nator]
	Date:		26.06.2025
	Version:	3.2
	
	History:	v1.0 @31.10.2016 - initial implementation in FS 17
				--------------------------------------------------------------------
				v2.0 @30.11.2018 - convert to FS 19
				--------------------------------------------------------------------
				v3.0 @18.11.2021 - convert to FS 22
				--------------------------------------------------------------------
				v3.1 @01.06.2025 - added compatibility for the "gpsSteeringLock" Mod
				--------------------------------------------------------------------
				v3.2 @26.06.2025 - added compatibility for patch 1.9.0.1 b33744
]]


AutoTurnOffTurnLights = {};

function AutoTurnOffTurnLights.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Drivable, specializations);
end;

function AutoTurnOffTurnLights.registerEventListeners(vehicleType)
	local functionNames = {
		"onLoad",
		"onUpdate"
	};
	
	for _, functionName in ipairs(functionNames) do
		SpecializationUtil.registerEventListener(vehicleType, functionName, AutoTurnOffTurnLights);
	end;
end;

function AutoTurnOffTurnLights:onLoad(savegame)
	local specDrivable = self.spec_drivable;
	
	specDrivable.hasSteeredToTurnLeftDirection = false;
	specDrivable.hasSteeredToTurnRightDirection = false;
end;

function AutoTurnOffTurnLights:onUpdate(dt, isActiveForInput, isActiveForInputIngnoreSelection, isSelected)
	if self:getIsActive() then
		local specDrivable = self.spec_drivable;

		if specDrivable.hasSteeredToTurnLeftDirection or specDrivable.hasSteeredToTurnRightDirection then
			local allowAutoTurnOffTurnLights = false;
			
			if specDrivable.hasSteeredToTurnLeftDirection then
				allowAutoTurnOffTurnLights = specDrivable.axisSide >= -0.001;
			elseif specDrivable.hasSteeredToTurnRightDirection then
				allowAutoTurnOffTurnLights = specDrivable.axisSide <= 0.001;
			end;
			
			if allowAutoTurnOffTurnLights then
				self:setTurnLightState(Lights.TURNLIGHT_OFF);
				
				specDrivable.hasSteeredToTurnLeftDirection = false;
				specDrivable.hasSteeredToTurnRightDirection = false;
			end;
		elseif self.spec_lights.turnLightState == Lights.TURNLIGHT_LEFT then
			specDrivable.hasSteeredToTurnLeftDirection = specDrivable.axisSide < -0.1;
		elseif self.spec_lights.turnLightState == Lights.TURNLIGHT_RIGHT then
			specDrivable.hasSteeredToTurnRightDirection = specDrivable.axisSide > 0.1;
		end;
	end;
end;